/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiPigmentGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.tile.machine.TileEntityPigmentMixer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class GuiPigmentMixer
extends GuiConfigurableTile<TileEntityPigmentMixer, MekanismTileContainer<TileEntityPigmentMixer>> {
    public GuiPigmentMixer(MekanismTileContainer<TileEntityPigmentMixer> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97731_ += 2;
        this.f_97728_ = 5;
        this.f_97729_ = 5;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        ((GuiBar)this.addRenderableWidget(new GuiHorizontalPowerBar((IGuiWrapper)this, ((TileEntityPigmentMixer)this.tile).getEnergyContainer(), 115, 75)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, ((TileEntityPigmentMixer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY))).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY_REDUCED_RATE, ((TileEntityPigmentMixer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityPigmentMixer)this.tile).getEnergyContainer(), ((TileEntityPigmentMixer)this.tile)::getEnergyUsed));
        this.addRenderableWidget(new GuiPigmentGauge(() -> ((TileEntityPigmentMixer)this.tile).leftInputTank, () -> ((TileEntityPigmentMixer)this.tile).getPigmentTanks(null), GaugeType.STANDARD, this, 25, 13)).warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, ((TileEntityPigmentMixer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_LEFT_INPUT));
        this.addRenderableWidget(new GuiPigmentGauge(() -> ((TileEntityPigmentMixer)this.tile).outputTank, () -> ((TileEntityPigmentMixer)this.tile).getPigmentTanks(null), GaugeType.STANDARD, this, 79, 4)).warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, ((TileEntityPigmentMixer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE));
        this.addRenderableWidget(new GuiPigmentGauge(() -> ((TileEntityPigmentMixer)this.tile).rightInputTank, () -> ((TileEntityPigmentMixer)this.tile).getPigmentTanks(null), GaugeType.STANDARD, this, 133, 13)).warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, ((TileEntityPigmentMixer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT));
        this.addRenderableWidget(((GuiProgress)new GuiProgress(((TileEntityPigmentMixer)this.tile)::getActive, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 47, 39).jeiCategory(this.tile)).colored(new LeftColorDetails())).warning(WarningTracker.WarningType.INPUT_DOESNT_PRODUCE_OUTPUT, ((TileEntityPigmentMixer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT));
        this.addRenderableWidget(((GuiProgress)new GuiProgress(((TileEntityPigmentMixer)this.tile)::getActive, ProgressType.SMALL_LEFT, (IGuiWrapper)this, 101, 39).jeiCategory(this.tile)).colored(new RightColorDetails())).warning(WarningTracker.WarningType.INPUT_DOESNT_PRODUCE_OUTPUT, ((TileEntityPigmentMixer)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT));
    }

    @Override
    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        this.drawString(matrix, this.f_96539_, this.f_97728_, this.f_97729_, this.titleTextColor());
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private class LeftColorDetails
    extends PigmentColorDetails {
        private LeftColorDetails() {
        }

        @Override
        public int getColorFrom() {
            return GuiPigmentMixer.this.tile == null ? -1 : this.getColor(((Pigment)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).leftInputTank.getType()).getColorRepresentation());
        }
    }

    private class RightColorDetails
    extends PigmentColorDetails {
        private RightColorDetails() {
        }

        @Override
        public int getColorFrom() {
            return GuiPigmentMixer.this.tile == null ? -1 : this.getColor(((Pigment)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).rightInputTank.getType()).getColorRepresentation());
        }
    }

    private abstract class PigmentColorDetails
    implements GuiProgress.ColorDetails {
        private WeakReference<PigmentMixingRecipe> cachedRecipe;

        private PigmentColorDetails() {
        }

        @Override
        public abstract int getColorFrom();

        @Override
        public int getColorTo() {
            if (GuiPigmentMixer.this.tile == null) {
                return -1;
            }
            if (((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).outputTank.isEmpty()) {
                if (!((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).leftInputTank.isEmpty() && !((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).rightInputTank.isEmpty()) {
                    PigmentMixingRecipe recipe;
                    PigmentStack leftInput = (PigmentStack)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).leftInputTank.getStack();
                    PigmentStack rightInput = (PigmentStack)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).rightInputTank.getStack();
                    if (this.cachedRecipe == null) {
                        recipe = this.getRecipeAndCache();
                    } else {
                        recipe = (PigmentMixingRecipe)this.cachedRecipe.get();
                        if (recipe == null || !this.isValid(recipe, leftInput, rightInput)) {
                            recipe = this.getRecipeAndCache();
                        }
                    }
                    if (recipe != null) {
                        return this.getColor(recipe.getOutput(leftInput, rightInput).getChemicalColorRepresentation());
                    }
                }
                return -1;
            }
            return this.getColor(((Pigment)((TileEntityPigmentMixer)((GuiPigmentMixer)GuiPigmentMixer.this).tile).outputTank.getType()).getColorRepresentation());
        }

        private PigmentMixingRecipe getRecipeAndCache() {
            PigmentMixingRecipe recipe = ((TileEntityPigmentMixer)GuiPigmentMixer.this.tile).getRecipe(0);
            this.cachedRecipe = recipe == null ? null : new WeakReference<PigmentMixingRecipe>(recipe);
            return recipe;
        }

        private boolean isValid(PigmentMixingRecipe recipe, PigmentStack leftInput, PigmentStack rightInput) {
            return ((ChemicalStackIngredient.PigmentStackIngredient)recipe.getLeftInput()).testType(leftInput) && ((ChemicalStackIngredient.PigmentStackIngredient)recipe.getRightInput()).testType(rightInput) || ((ChemicalStackIngredient.PigmentStackIngredient)recipe.getLeftInput()).testType(rightInput) && ((ChemicalStackIngredient.PigmentStackIngredient)recipe.getRightInput()).testType(leftInput);
        }

        protected int getColor(int tint) {
            if ((tint & 0xFF000000) == 0) {
                return 0xFF000000 | tint;
            }
            return tint;
        }
    }
}

